#include <applications/dialog/FirmwareDialog.h>
#include <applications/dialog/SettingDialog.h>
#include <cstdio>
#include <hal/devices.h>
#include <hal/drivers/buzzer.h>

CFirmwareDialog FirmwareDialog;

void CFirmwareDialog::OnCreat(void)
{
	first_line = 0;

	OnDraw();
}

void CFirmwareDialog::OnEncoderCW(void)
{
	if (first_line < ((sizeof(configure_file.version) + 14) / 16) - 4)
	{
		++first_line;
	}
	else
	{
		beep(10);
	}

	OnDraw();
}

void CFirmwareDialog::OnEncoderCCW(void)
{
	if (first_line > 0)
	{
		--first_line;
	}
	else
	{
		beep(10);
	}

	OnDraw();
}

void CFirmwareDialog::OnButtonDown(void)
{
	p_dialog = &SettingDialog;
	p_dialog->OnCreat();
}

void CFirmwareDialog::OnDraw(void)
{
	rewind(p_lcd);
	fwrite(zeros, 128, 1, p_lcd);

	rewind(p_lcd);

	fprintf(p_lcd, "%.64s", &configure_file.version[first_line * 16]);

	fflush(p_lcd);
}
